* age_structure.sas;
options pageno=1 linesize=80;
goptions reset=all;
title "Tests of independence - age structure";
data age;
	input pop $ age $ obsfreq;
	datalines;
1  0  36
1  1  22
1  2  18
1  3  13
1  4  11
2  0  48
2  1  24
2  2  14
2  3  10
2  4   4
3  0  60
3  1  21
3  2  12
3  3   5
3  4   2
;
run;
* Print data set;
proc print data=age;
run;
* Tests of independence;
proc freq data=age order=data;
	tables age*pop / chisq cellchi2 expected out=percents outpct;
	weight obsfreq;
	* Can compute an exact test if frequencies are low;
	* Not recommended for large data sets;
	*exact chisq;
run;
* Print output data file containing percents;
proc print data=percents;
run;
* Generate bar chart showing percentages;
proc gchart data=percents;
	vbar pop / sumvar=pct_col subgroup=age width=10 woutline=3 
	raxis=axis1 maxis=axis2 legend=legend1;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
	axis2 label=(height=2) value=(height=2) width=3;
	legend1 label=(height=2) value=(height=2);
run;
quit;
